import pandas as pd  
import numpy as np
from sklearn.preprocessing import StandardScaler 
import pickle
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  
  
# Identify numerical variables  
numerical_columns = credit_customers.select_dtypes(include=['number']).columns  
  
# Calculate the range of each numerical column  
ranges = {}  
for col in numerical_columns:  
    ranges[col] = credit_customers[col].max() - credit_customers[col].min()  
  
# Check if normalization is necessary  
normalization_needed = False  
for col, range_ in ranges.items():  
    if range_ > 1:  
        normalization_needed = True  
        break  
  
# It's true:  
# Normalize the data using Standard Scaling  
scaler = StandardScaler()  
credit_customers_normalized = credit_customers.copy()  
credit_customers_normalized[numerical_columns] = scaler.fit_transform(credit_customers[numerical_columns])  
  
print("Data after Standard Scaling:\n", credit_customers_normalized.head())  
pickle.dump(credit_customers_normalized.head(),open("./ref_result/credit_customers_normalized_head.pkl","wb"))
